/*
 * Note: This file is recreated by the project wizard whenever the MCU is
 *       changed and should not be edited by hand
 */

/* Include the derivative-specific header file */
#include "MKL25Z4.h"	
#include "mcg.h"

////////////////////////////////////////
/////// Target Global Definitions //////
////////////////////////////////////////


#define gClko_Type_c           CRYSTAL

#define USE_32MHZ_CLKO                                                          //Enable this macro when using a 32MHZ crystal fed to the MKW01Z128CHN   
//#define USE_30MHZ_CLKO                                                        //Enable this macro when using a 30MHz crystal fed to the MKW01Z128CHN

/******************************
Radio CLKOUT= 2MHz
PLL input= 2MHz (Prdiv=1)
MCG out= 48MHz
PLL out Clk= 24MHz
BusClk= MCG out/2= 24 MHz
******************************/
/*Test 2MHz CLKOUT*/
/*  #define gClk0_Freq_Hz_c       2000000				
  #define gPll0_Prdiv_c         1					        //Valid values from 1-25
  #define gPll0_Vdiv_c          24					        //Valid values from 24-55
*/
/******************************
Radio CLKOUT= 32MHz
PLL input= 2MHz (Prdiv=16)
MCG out= 48MHz
PLL out Clk= 24MHz
BusClk= MCG out/2= 24 MHz
******************************/
#ifdef USE_32MHZ_CLKO
  #define gClk0_Freq_Hz_c       32000000				
  #define gPll0_Prdiv_c         16					        //Valid values from 1-25
  #define gPll0_Vdiv_c          24					        //Valid values from 24-55
#endif

/******************************
Radio CLKOUT= 30MHz
PLL input= 2MHz (Prdiv=15)
MCG out= 48MHz
PLL out Clk= 24MHz
BusClk= MCG out/2= 24 MHz
******************************/
#ifdef USE_30MHZ_CLKO                                                
  #define gClk0_Freq_Hz_c       30000000				
  #define gPll0_Prdiv_c         15					        //Valid values from 1-25
  #define gPll0_Vdiv_c          24					        //Valid values from 24-55
#endif


////////////////////////////////////////
/////// KEYBOARD port mapping //////////
////////////////////////////////////////

/*
 * Keyboard1 Port Data Direction register mapping
 */
#define gKeyboard1_PortDataDirReg_c                    GPIOA_PDDR

/*
 * Keyboard2 Port Data Direction register mapping
 */
#define gKeyboard2_PortDataDirReg_c                    GPIOD_PDDR

/*
 * Keyboard1 pin definition
 */
#define gKeyboard_Keyboard1Pin_c                        (1<<4)

/*
 * Keyboard2 pin definition
 */
#define gKeyboard_Keyboard2Pin_c                        (1<<5) 

/*
 * Keyboard (PORT A and PORT D) port clock gating register mapping
 */
#define gKeyboard_ClkGatingReg_c                        SIM_SCGC5

/*
 * Keyboard1 (PORT A) port clock gating bit 
 */
#define gKeyboard1_ClkGatingBit_c                       (1<<9)        

/*
 * Keyboard2 (PORT D) port clock gating bit 
 */
#define gKeyboard2_ClkGatingBit_c                       (1<<12)     

/*
 * Keyboard Pin Control Alternate Function 
 */
#define gKeyboard_PinCtrlAltFunc_c                      (1)
   
/*
* Keyboard Pin Interrupt configuration 
*/
#define gKeyboard_PinIrqFallingEdge_Func_c              (0x0A)
#define gKeyboard_PinIrqRisingEdge_Func_c               (0x09)

/*
 * Keyboard1 Pin Control register mapping
 */
#define gKeyboard_Keyboard1PinCtrlReg_c                 PORTA_PCR4     

/*
 * Keyboard2 Pin Control register mapping
 */
#define gKeyboard_Keyboard2PinCtrlReg_c                 PORTD_PCR5     
   
////////////////////////////////////////
///////////////// TPM Timer ////////////
////////////////////////////////////////

/*
 * Name: TPM_INSTANCES
 * Description: TPM System Integration Module register macros
 */ 

#define gTPM0_SIM_SCGC_REG_c                    SIM_SCGC6
#define gTPM1_SIM_SCGC_REG_c                    SIM_SCGC6
#define gTPM2_SIM_SCGC_REG_c                    SIM_SCGC6

#define gTPMx_SIM_SOPT_REG_c                    SIM_SOPT2     


////////////////////////////////////////
///////////////// UART /////////////////
////////////////////////////////////////

/*
 * Name: UART_NR_INSTANCES
 * Description: number of UART peripherals on board
 */ 
#define  gUART_HW_MODULES_AVAILABLE_c            1

#define gUART_HW_MOD_0_c                         0
#define gUART_HW_MOD_1_c                         1


#define gUART0_BASE_PTR_c                        UART0_BASE_PTR
#define gUART1_BASE_PTR_c                        UART1_BASE_PTR


#define gUART0_IRQ_NUM_c                         (INT_UART0-16)
#define gUART0_ERR_IRQ_NUM_c                     (INT_UART0-16)
#define gUART1_IRQ_NUM_c                         (INT_UART1-16)
#define gUART1_ERR_IRQ_NUM_c                     (INT_UART1-16)


#define gUART0_SIM_SCGC_REG_c                    SIM_SCGC4
#define gUART1_SIM_SCGC_REG_c                    SIM_SCGC4


#define gUART0_SIM_SCGC_BIT_c                    (10)
#define gUART1_SIM_SCGC_BIT_c                    (11)


#define gUART0_PORT_SIM_SCGC_REG_c               SIM_SCGC5       /* Port clock gating register */
#define gUART0_PORT_SIM_SGC_BIT_c                (1<<9)          /* Port clock gating bit */
#define gUART0_PORT_MUX_c                        (2)             /* Port MUX (alternate function) */
#define gUART0_RX_PCR_REG_c                      PORTA_PCR1      /* Port Control Register (PCR) associated with RX pin */
#define gUART0_TX_PCR_REG_c                      PORTA_PCR2      /* Port Control Register (PCR) associated with TX pin */
#define gUART0_RTS_PCR_REG_c                     PORTA_PCR3      /* Port Control Register (PCR) associated with RTS pin */
#define gUART0_CTS_PCR_REG_c                     PORTA_PCR4      /* Port Control Register (PCR) associated with CTS pin */

#define gUART1_PORT_SIM_SCGC_REG_c               SIM_SCGC5       /* Port clock gating register */
#define gUART1_PORT_SIM_SGC_BIT_c                (1<<9)         /* Port clock gating bit */
#define gUART1_PORT_MUX_c                        (2)             /* Port MUX (alternate function) */
#define gUART1_RX_PCR_REG_c                      PORTA_PCR1      /* Port Control Register (PCR) associated with RX pin */
#define gUART1_TX_PCR_REG_c                      PORTA_PCR2      /* Port Control Register (PCR) associated with TX pin */
#define gUART1_RTS_PCR_REG_c                     PORTC_PCR1      /* Port Control Register (PCR) associated with RTS pin */
#define gUART1_CTS_PCR_REG_c                     PORTC_PCR4      /* Port Control Register (PCR) associated with CTS pin */



/* Uart1 flags masks */

#define gUART_C2_TCIE_MASK			 UARTLP_C2_TCIE_MASK

/* Error flags masks */
#define gUART_PARITY_ERROR_FLAG_c                (0x1u)              
#define gUART_FRAME_ERROR_FLAG_c                 (0x2u)
#define gUART_NOISE_FLAG_c                       (0x4u)
#define gUART_OVERRUN_FLAG_c                     (0x8u)

/* Parity masks */
#define gUART_PARITY_EN_BIT_c                    (0x2u)
#define gUART_PARITY_EVEN_BIT_c                  (0x1u)

/* Data bits mask */
#define gUART_DATA_BITS_BIT_c                    (0x8u)

/* FIFO flush masks */
#define gUART_TX_FIFO_FLUSH_c                    (0x80u)
#define gUART_RX_FIFO_FLUSH_c                    (0x40u)

/* TX/RX enable bits mask */
#define gUART_TX_EN_BIT_c                        (0x8u)
#define gUART_RX_EN_BIT_c                        (0x4u)

/* UART RX/TX interrupt masks */
#define gUART_RX_INT_BIT_c                       (0x20u)
#define gUART_TX_INT_BIT_c                       (0x40u)

/* UART RX/TX interrupt enable masks */
#define gUART_TIE_BIT_c                          (0x80u)
#define gUART_RIE_BIT_c                          (0x20u)
                    

/* UART baudrate masks */
#define gUART_BDH_MASK_c                         (0x001Fu)
#define gUART_BDL_MASK_c                         (0x00FFu)
#define gUART_BRFA_MASK_c                        (0x1F)

#define gUART_TX_FIFO_EN_BIT_c                   (0x80)     /* transmit FIFO enable bit */  
#define gUART_TX_FIFO_MASK_c                     (0x70)     /* transmit FIFO buffer depth mask */

#define gUART_RX_FIFO_EN_BIT_c                   (0x8)      /* receive FIFO enable bit */
#define gUART_RX_FIFO_MASK_c                     (0x7)      /* receive FIFO buffer depth mask */

#define gUART_S1_TDRE_MASK_c                     (0x80)    /* TDRE bit mask */
#define gUART_S1_RDRF_MASK_c                     (0x20)    /* RDRF bit mask */  


////////////////////////////////////////
/////// Define LED port mapping ////////
////////////////////////////////////////

/*
 * LED Port Data Output register mapping
 */
#define gLED1_PortDataOutReg_c                    GPIOA_PDOR
#define gLED2n4_PortDataOutReg_c                  GPIOE_PDOR
#define gLED3_PortDataOutReg_c                    GPIOB_PDOR

/*
 * LED Port Data Direction register mapping
 */
#define gLED1_PortDataDirReg_c                    GPIOA_PDDR
#define gLED2n4_PortDataDirReg_c                  GPIOE_PDDR
#define gLED3_PortDataDirReg_c                    GPIOB_PDDR

/*
 * LED Port Data Set register mapping 
 */
#define gLED1_PortDataSetReg_c                    GPIOA_PSOR
#define gLED2n4_PortDataSetReg_c                  GPIOE_PSOR
#define gLED3_PortDataSetReg_c                    GPIOB_PSOR

/*
 * LED Port Data Clear register mapping
 */
#define gLED1_PortDataClearReg_c                  GPIOA_PCOR
#define gLED2n4_PortDataClearReg_c                GPIOE_PCOR
#define gLED3_PortDataClearReg_c                  GPIOB_PCOR

/*
 * LED Port Data Toggle register mapping
 */
#define gLED1_PortDataToggleReg_c                 GPIOA_PTOR
#define gLED2n4_PortDataToggleReg_c               GPIOE_PTOR
#define gLED3_PortDataToggleReg_c                 GPIOB_PTOR

/*
 * LED 1 pin definition
 */
#define gLED_Led1Pin_c                        	 (1<<19) 	

/*
 * LED 2 pin definition
 */
#define gLED_Led2Pin_c                           (1<<16)	

/*
 * LED 3 pin definition
 */
#define gLED_Led3Pin_c                            (1<<0) 	

/*
 * LED 4 pin definition
 */
#define gLED_Led4Pin_c                            (1<<17) 	

/*
 * LED 1 Pin Control register mapping
 */
#define gLED_Led1PinCtrlReg_c                    PORTA_PCR19 	

/*
 * LED 2 Pin Control register mapping
 */
#define gLED_Led2PinCtrlReg_c                    PORTE_PCR16	

/*
 * LED 3 Pin Control register mapping
 */
#define gLED_Led3PinCtrlReg_c                    PORTB_PCR0		

/*
 * LED 4 Pin Control register mapping
 */
#define gLED_Led4PinCtrlReg_c                    PORTE_PCR17 

/*
 * LED port clock gating register mapping
 */
#define gLED_ClkGatingReg_c                      SIM_SCGC5

/*
 * LED port clock gating bit 
 */
#define gLED_ClkGatingBit_c                      (SIM_SCGC5_PORTA_MASK | SIM_SCGC5_PORTB_MASK | SIM_SCGC5_PORTE_MASK) //(1<<10)

/*
 * LED Pin Control Alternate Function
 */
#define gLED_PinCtrlAltFunc_c                    1

/*
 * LEDs count on target board
 */
#define gLEDsOnTargetBoardCnt_c                  4	
   
////////////////////////////////////////
///////// Radio port mapping ///////////
////////////////////////////////////////   
                   

#define Radio_IRQ_DIO1_PCR                   PORTD_PCR7        /* Port D Pin Control Register 6 */    
#define Radio_IRQ_DIO1_PinNumberMask_c       (1<<7)                                                 
   
#define Radio_IRQ_DIO0_PCR                   PORTD_PCR6        /* Port D Pin Control Register 7 */       
#define Radio_IRQ_DIO0_PinNumberMask_c       (1<<6)                                                   


#define Radio_IRQ_DIO4_PCR                   PORTD_PCR4        /* Port D Pin Control Register 7 */   
#define Radio_IRQ_DIO4_PinNumberMask_c       (1<<4)            
   
#define Radio_Irq_Number                    (INT_PORTD-16) 

/* IRQ GPIO PORT  Clock Gating Control Register */
#define Radio_IRQ_PORT_SIM_SCG          SIM_SCGC5
#define cIRQ_PORT_SIM_SCG_Mask_c        (1<<12)           /*PORT D Clock Gate Control enable*/
   
/* IRQ GPIO Registers */ 
#define Radio_IRQ_PDOR          GPIOD_PDOR        /* Port Data Output Register */
#define Radio_IRQ_PSOR          GPIOD_PSOR        /* Port Set Output Register */
#define Radio_IRQ_PCOR          GPIOD_PCOR        /* Port Clear Output Register */
#define Radio_IRQ_PTOR          GPIOD_PTOR        /* Port Toggle Output Register */
#define Radio_IRQ_PDIR          GPIOD_PDIR        /* Port Data Input Register */
#define Radio_IRQ_PDDR          GPIOD_PDDR        /* Port Data Direction Register */ 


/////////////////////////////////////////////////
////  Global macro for accesing Radio pins //////
////////////////////////////////////////////////


#define gMKW01RadioResetPort                 PORTE_PCR30        
#define gMKW01ResetMask_c                    (1<<30)            

#define MKW01x_RESET_PORT_SIM_SCG            SIM_SCGC5    
   
#define cRESET_PORT_SIM_SCG_Config_c         (1<<13)         /*Reset Radio Clock Gate Control enable*/  

/*
 * Name: gRadioReset_DataAvailablePortDataOUTReg_c     
 * Description: Port Data Output register mapping
 */
#ifndef gRadioReset_DataAvailablePortDataOUTReg_c
#define gRadioReset_DataAvailablePortDataOUTReg_c       GPIOE_PDOR      
#endif

/* * Name: gRadioReset_SetPortOutReg_c      
 * Description: Port Clear Output register mapping
*/
#ifndef gRadioReset_SetPortOutReg_c
#define gRadioReset_SetPortOutReg_c                     GPIOE_PSOR    
#endif   
   
/*
 * Name: gRadioReset_ClearPortOutReg_c      
 * Description: Port Clear Output register mapping
 */
#ifndef gRadioReset_ClearPortOutReg_c
#define gRadioReset_ClearPortOutReg_c                     GPIOE_PCOR   
#endif


/*
 * Name: gRadioReset_DataAvailablePortDDirReg_c
 * Description: Port Data Direction register mapping
 */
#ifndef gRadioReset_DataAvailablePortDDirReg_c
#define gRadioReset_DataAvailablePortDDirReg_c          GPIOE_PDDR      
#endif
   
#define gMKW01ClkOutPort     GPIOA_PDIR                                 
#define gMKW01ClkOutMask_c   (1<<18)                                    
   
#define gMKW01SpiSsMask_c    (1<<4)
#define gMKW01SpiMisoMask_c  (1<<7)
#define gMKW01SpiMosiMask_c  (1<<6)
#define gMKW01SpiSpsckMask_c (1<<5)

#define gMKW01DIOPort               GPIOD_PDOR

#define gMKW01DIO_2Mask_c     Not defined
#define gMKW01DIO_3Mask_c     Not defined
#define gMKW01DIO_4Mask_c     Not defined 
   
   
#define gMKW01PacketSentMask_c     gMKW01DIO_0Mask_c
#define gMKW01FifoLevelMask_c      gMKW01DIO_1Mask_c
#define gMKW01FifoNotEmptyMask_c   gMKW01DIO_2Mask_c
#define gMKW01FifoFullMask_c       gMKW01DIO_3Mask_c
#define gMKW01ModeReadyMask_c      gMKW01DIO_4Mask_c
#define gMKW01SyncAddressMask_c    gMKW01DIO_0Mask_c
#define gMKW01PayloadReadyMask_c   gMKW01DIO_0Mask_c
#define gMKW01RxReadyMask_c        gMKW01DIO_4Mask_c
   
   
#define gMKW01PacketSentRisingEdge_c   gMKW01DIO_0Mask_c
#define gMKW01FifoLevelRisingEdge_c    gMKW01DIO_1Mask_c
#define gMKW01FifoLevelFallingEdge_c   0x00
#define gMKW01SyncAddressRisingEdge_c  gMKW01DIO_0Mask_c
#define gMKW01PayloadReadyRisingEdge_c gMKW01DIO_0Mask_c
#define gMKW01RxReadyRisingEdge_c      gMKW01DIO_4Mask_c
   
   
////////////////////////////////////////
/////// Define SPI port mapping ////////
////////////////////////////////////////

/*
 *  SPI PCS Pin Control Register mapping
 */
#define SPI_PCS_PCR                              PORTC_PCR4
#define SPI_PCS_ALT_FUNC                         2

/*
 *  SPI SCK Pin Control Register mapping
 */
#define SPI_SCK_PCR                              PORTC_PCR5
#define SPI_SCK_ALT_FUNC                         2

/*
 *  SPI SOUT (MOSI) Pin Control Register mapping
 */
#define SPI_MOSI_PCR                             PORTC_PCR6
#define SPI_MOSI_ALT_FUNC                        2

/*
 * SPI SIN (MISO) Pin Control Register mapping
 */
#define SPI_MISO_PCR                              PORTC_PCR7
#define SPI_MISO_ALT_FUNC                         2



   
/*
 * Name: gSPI_DataAvailablePortDataINReg_c      
 * Description: Port Data Input register mapping
 */
#ifndef gSPI_DataAvailablePortDataINReg_c
#define gSPI_DataAvailablePortDataINReg_c        GPIOC_PDIR
#endif


/*
 * Name: gSPI_ClearPortOutReg_c      
 * Description: Port Clear Output register mapping
 */
#ifndef gSPI_ClearPortOutReg_c
#define gSPI_ClearPortOutReg_c                     GPIOC_PCOR
#endif
  
/*
* Name: gSPI_SetPortOutReg_c      
* Description: Port Clear Output register mapping
*/
#ifndef gSPI_SetPortOutReg_c
#define gSPI_SetPortOutReg_c                     GPIOC_PSOR
#endif
   
/*
 * Name: gSPI_DataAvailablePortDataOUTReg_c     
 * Description: Port Data Output register mapping
 */
#ifndef gSPI_DataAvailablePortDataOUTReg_c
#define gSPI_DataAvailablePortDataOUTReg_c       GPIOC_PDOR           
#endif

/*
 * Name: gSPI_DataAvailablePortDDirReg_c
 * Description: Port Data Direction register mapping
 */
#ifndef gSPI_DataAvailablePortDDirReg_c
#define gSPI_DataAvailablePortDDirReg_c          GPIOC_PDDR
#endif

/*
 * Name: gSPI_DataAvailablePinMask_c
 * Description: Port Data register pin mask
 */
#ifndef gSPI_DataAvailablePinMask_c
#define gSPI_DataAvailablePinMask_c              (1<<4)
#endif


   

////////////////////////////////////////
/////// Define IIC port mapping ////////
////////////////////////////////////////

/*
 * Name: I2C_0
 * Description: mapping convention for I2C hardware module #0
 */
#define I2C_0           0

/*
 * Name: I2C_1
 * Description: mapping convention for I2C hardware module #1
 */
#define I2C_1           1

/*
 * Name: gI2C_USED_d
 * Description: The I2C hardware module used
 */
#ifndef gI2C_USED_d
#define gI2C_USED_d     I2C_0
#endif

/*
 * Name: gI2C_USED_PORT
 * Description: specifies which HW port is used by the I2C module
 */
#if (gI2C_USED_d == I2C_0)
#define I2C_ON_PTB0_PTB1       0 /* mapping convention for I2C HW module #0 used on PTB0 and PTB1 pins */
#define I2C_ON_PTB2_PTB3       1 /* mapping convention for I2C HW module #0 used on PTB2 and PTB3 pins */
#define I2C_ON_PTD8_PTD9       2 /* mapping convention for I2C HW module #0 used on PTD8 and PTD9 pins */
#define gI2C_USED_PORT         I2C_ON_PTD8_PTD9 /* the I2C pins selected to be used from the list above */
#else
#define I2C_ON_PTE0_PTE1       3 /* mapping convention for I2C HW module #1 used on PTE0 and PTE1 pins */
#define I2C_ON_PTC10_PTC11     4 /* mapping convention for I2C HW module #1 used on PTC10 and PTC11 pins */
#define gI2C_USED_PORT         I2C_ON_PTE0_PTE1 /* the I2C pins selected to be used from the list above */
#endif

/* Setup the Port Data register */
#ifndef gIIC_TxDataAvailablePortDataReg_c
#define gIIC_TxDataAvailablePortDataReg_c        GPIOE_PDOR  
#endif

/* Setup the Port Data Direction register*/
#ifndef gIIC_TxDataAvailablePortDDirReg_c
#define gIIC_TxDataAvailablePortDDirReg_c        GPIOE_PDDR
#endif

/* Setup the Port Data register pin mask */
#ifndef gIIC_TxDataAvailablePinMask_c                           
#define gIIC_TxDataAvailablePinMask_c            (1<<2)
#endif

/* Setup the Pin Control register */
#ifndef gIIC_TxDataAvailablePinCtrlReg_c
#define gIIC_TxDataAvailablePinCtrlReg_c         PORTE_PCR2
#endif

/* Setup the Pin Control register mask */
#ifndef gIIC_TxDataAvailablePinCtrlMask_c
#define gIIC_TxDataAvailablePinCtrlMask_c        (0x01000100UL) // (ISF=0, MUX=1)        
#endif

/* Setup the Pin Control register value */
#ifndef gIIC_TxDataAvailablePinCtrlValue_c
#define gIIC_TxDataAvailablePinCtrlValue_c       (0x0100UL)      
#endif

/* Setup the System Clock Gating Control register */
#ifndef gIIC_TxDataAvailablePortClkGatingReg_c
#define gIIC_TxDataAvailablePortClkGatingReg_c   SIM_SCGC5
#endif

/* Setup the System Clock Gating Control register bit */
#ifndef gIIC_TxDataAvailablePortClkGatingBit_c
#define gIIC_TxDataAvailablePortClkGatingBit_c   (1<<13)
#endif

/*
 * Name: I2C_SIM_SCGC_c
 * Description: I2C module clock gating
 */
#if (gI2C_USED_d == I2C_0)
#define I2C_SIM_SCGC_c                           SIM_SCGC4            /* I2C0 system clock gating control register */
#define I2C_SIM_SCGC_BIT_c                       (1<<6)                       /* I2C0 system clock gating control bit position */
#else 
#define I2C_SIM_SCGC_c                           SIM_SCGC4            /* I2C1 system clock gating control register */
#define I2C_SIM_SCGC_BIT_c                       (1<<7)                       /* I2C1 system clock gating control bit position */
#endif

/*
 * Name: I2C_PORT_SIM_SCG
 * Description: I2C port clock gating
 */
#define I2C_PORT_SIM_SCG                         SIM_SCGC5

/*
 * Name: see section below
 * Description: I2C SCL and SDA Pin Control Register (PCR) settings
 */
#if (gI2C_USED_PORT == I2C_ON_PTB0_PTB1)
#define I2C_PORT_SIM_SGC_BIT                     (1<<10)
/* SCL = PTB0, ALT = 2 */
#define I2C_SCL_PCR                              PORTB_PCR0
#define I2C_SCL_PCR_MASK                         (0x01000520UL)
#define I2C_SCL_PCR_VAL                          (0x0220UL)     
/* SDA = PTB1, ALT 2 */
#define I2C_SDA_PCR                              PORTB_PCR1
#define I2C_SDA_PCR_MASK                         (0x01000520UL)
#define I2C_SDA_PCR_VAL                          (0x0220UL) 
#elif (gI2C_USED_PORT == I2C_ON_PTB2_PTB3)
#define I2C_PORT_SIM_SGC_BIT                     (1<<10)
/* SCL = PTB2, ALT = 2 */
#define I2C_SCL_PCR                              PORTB_PCR2
#define I2C_SCL_PCR_MASK                         (0x01000520UL)
#define I2C_SCL_PCR_VAL                          (0x0220UL)
/* SDA = PTB3, ALT 2 */
#define I2C_SDA_PCR                              PORTB_PCR3
#define I2C_SDA_PCR_MASK                         (0x01000520UL)
#define I2C_SDA_PCR_VAL                          (0x0220UL)
#elif (gI2C_USED_PORT == I2C_ON_PTD8_PTD9)
#define I2C_PORT_SIM_SGC_BIT                     (1<<12)
/* SCL = PTD8, ALT = 2 */               
#define I2C_SCL_PCR                              PORTD_PCR8
#define I2C_SCL_PCR_MASK                         (0x01000520UL)
#define I2C_SCL_PCR_VAL                          (0x0220UL)
/* SDA = PTD9, ALT 2 */
#define I2C_SDA_PCR                              PORTD_PCR9
#define I2C_SDA_PCR_MASK                         (0x01000520UL)
#define I2C_SDA_PCR_VAL                          (0x0220UL)
#elif (gI2C_USED_PORT == I2C_ON_PTE0_PTE1)
#define I2C_PORT_SIM_SGC_BIT                     (1<<13)
/* SCL = PTE0, ALT = 6 */
#define I2C_SCL_PCR                              PORTE_PCR0
#define I2C_SCL_PCR_MASK                         (0x01000120UL)
#define I2C_SCL_PCR_VAL                          (0x0620UL)
/* SDA = PTE1, ALT 6 */
#define I2C_SDA_PCR                              PORTE_PCR1
#define I2C_SDA_PCR_MASK                         (0x01000120UL)
#define I2C_SDA_PCR_VAL                          (0x0620UL)
#elif (gI2C_USED_PORT == I2C_ON_PTC10_PTC11)
#define I2C_PORT_SIM_SGC_BIT                     (1<<11)
/* SCL = PTC10, ALT = 2 */
#define I2C_SCL_PCR                              PORTC_PCR10
#define I2C_SCL_PCR_MASK                         (0x01000520UL)
#define I2C_SCL_PCR_VAL                          (0x0220UL)
/* SDA = PTC11, ALT 2 */
#define I2C_SDA_PCR                              PORTC_PCR11
#define I2C_SDA_PCR_MASK                         (0x01000520UL)
#define I2C_SDA_PCR_VAL                          (0x0220UL)
#else 
#error "I2C port is not specified or it's not valid"
#endif
   
   
